/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.enhancement.text;

import club.sk1er.mods.core.util.Multithreading;
import club.sk1er.patcher.util.enhancement.Enhancement;
import club.sk1er.patcher.util.enhancement.text.CachedString;
import club.sk1er.patcher.util.hash.StringHash;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GLAllocation;

public final class EnhancedFontRenderer
implements Enhancement {
    private static final List<EnhancedFontRenderer> instances = new ArrayList<EnhancedFontRenderer>();
    private final List<StringHash> obfuscated = new ArrayList<StringHash>();
    private final Map<String, Integer> stringWidthCache = new HashMap<String, Integer>();
    private final Queue<Integer> glRemoval = new ConcurrentLinkedQueue<Integer>();
    private final Cache<StringHash, CachedString> stringCache = Caffeine.newBuilder().writer((CacheWriter)new RemovalListener()).executor((Executor)Multithreading.POOL).maximumSize(5000L).build();

    public EnhancedFontRenderer() {
        instances.add(this);
    }

    public static List<EnhancedFontRenderer> getInstances() {
        return instances;
    }

    @Override
    public String getName() {
        return "Enhanced Font Renderer";
    }

    @Override
    public void tick() {
        this.stringCache.invalidateAll(this.obfuscated);
        this.obfuscated.clear();
    }

    public int getGlList() {
        Integer poll = this.glRemoval.poll();
        return poll == null ? GLAllocation.func_74526_a((int)1) : poll;
    }

    public Queue<Integer> getGlRemoval() {
        return this.glRemoval;
    }

    public void invalidate() {
        this.stringCache.invalidateAll();
    }

    public CachedString get(StringHash key) {
        return (CachedString)this.stringCache.getIfPresent((Object)key);
    }

    public void cache(StringHash key, CachedString value) {
        this.stringCache.put((Object)key, (Object)value);
    }

    public Map<String, Integer> getStringWidthCache() {
        return this.stringWidthCache;
    }

    public void invalidateAll() {
        this.stringCache.invalidateAll();
    }

    public List<StringHash> getObfuscated() {
        return this.obfuscated;
    }

    private class RemovalListener
    implements CacheWriter<StringHash, CachedString> {
        private RemovalListener() {
        }

        public void write(@Nonnull StringHash key, @Nonnull CachedString value) {
        }

        public void delete(@Nonnull StringHash key, CachedString value, @Nonnull RemovalCause cause) {
            if (value == null) {
                return;
            }
            EnhancedFontRenderer.this.glRemoval.add(value.getListId());
        }
    }
}

